/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import com.iCo6.Constants;
import com.iCo6.iConomy;
import com.iCo6.system.Accounts;
import com.iCo6.system.Holdings;
import java.util.List;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_iConomy6
extends AbstractEconomy {
    private final Logger log;
    private String name = "iConomy ";
    private Plugin plugin = null;
    protected iConomy economy = null;
    private Accounts accounts;

    public Economy_iConomy6(Plugin plugin) {
        Plugin ec;
        this.plugin = plugin;
        this.log = plugin.getLogger();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        this.log.warning("iConomy - If you are using Flatfile storage be aware that versions 6, 7 and 8 have a CRITICAL bug which can wipe ALL iconomy data.");
        this.log.warning("if you're using Votifier, or any other plugin which handles economy data in a threaded manner your server is at risk!");
        this.log.warning("it is highly suggested to use SQL with iCo6 or to use an alternative economy plugin!");
        if (this.economy == null && (ec = plugin.getServer().getPluginManager().getPlugin("iConomy")) != null && ec.isEnabled() && ec.getClass().getName().equals("com.iCo6.iConomy")) {
            String version = ec.getDescription().getVersion().split("\\.")[0];
            this.name = this.name + version;
            this.economy = (iConomy)ec;
            this.accounts = new Accounts();
            this.log.info(String.format("[Economy] %s hooked.", this.name));
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.economy == null) {
            return false;
        }
        return this.economy.isEnabled();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String format(double amount) {
        return iConomy.format((double)amount);
    }

    @Override
    public String currencyNameSingular() {
        return (String)Constants.Nodes.Major.getStringList().get(0);
    }

    @Override
    public String currencyNamePlural() {
        return (String)Constants.Nodes.Major.getStringList().get(1);
    }

    @Override
    public double getBalance(String playerName) {
        if (this.accounts.exists(playerName)) {
            return this.accounts.get(playerName).getHoldings().getBalance();
        }
        return 0.0;
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        Holdings holdings = this.accounts.get(playerName).getHoldings();
        if (holdings.hasEnough(amount)) {
            holdings.subtract(amount);
            return new EconomyResponse(amount, holdings.getBalance(), EconomyResponse.ResponseType.SUCCESS, null);
        }
        return new EconomyResponse(0.0, holdings.getBalance(), EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot desposit negative funds");
        }
        Holdings holdings = this.accounts.get(playerName).getHoldings();
        holdings.add(amount);
        return new EconomyResponse(amount, holdings.getBalance(), EconomyResponse.ResponseType.SUCCESS, null);
    }

    @Override
    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        if (this.accounts.exists(name)) {
            return new EconomyResponse(0.0, this.accounts.get(name).getHoldings().getBalance(), EconomyResponse.ResponseType.FAILURE, "That account already exists.");
        }
        boolean created = this.accounts.create(name);
        if (created) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "There was an error creating the account");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        if (this.accounts.exists(name)) {
            this.accounts.remove(new String[]{name});
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "That bank account does not exist.");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        if (this.has(name, amount)) {
            return new EconomyResponse(0.0, amount, EconomyResponse.ResponseType.SUCCESS, "");
        }
        return new EconomyResponse(0.0, this.accounts.get(name).getHoldings().getBalance(), EconomyResponse.ResponseType.FAILURE, "The account does not have enough!");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        return this.withdrawPlayer(name, amount);
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot desposit negative funds");
        }
        return this.depositPlayer(name, amount);
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy 6 does not support Bank owners.");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "iConomy 6 does not support Bank members.");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        if (!this.accounts.exists(name)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "There is no bank account with that name");
        }
        return new EconomyResponse(0.0, this.accounts.get(name).getHoldings().getBalance(), EconomyResponse.ResponseType.SUCCESS, null);
    }

    @Override
    public List<String> getBanks() {
        throw new UnsupportedOperationException("iConomy does not support listing of bank accounts");
    }

    @Override
    public boolean hasBankSupport() {
        return true;
    }

    @Override
    public boolean hasAccount(String playerName) {
        return this.accounts.exists(playerName);
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        if (this.hasAccount(playerName)) {
            return false;
        }
        return this.accounts.create(playerName);
    }

    @Override
    public int fractionalDigits() {
        return -1;
    }

    @Override
    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    @Override
    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    @Override
    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    @Override
    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public class EconomyServerListener
    implements Listener {
        Economy_iConomy6 economy = null;

        public EconomyServerListener(Economy_iConomy6 economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin ec;
            if (this.economy.economy == null && (ec = event.getPlugin()).getClass().getName().equals("com.iCo6.iConomy")) {
                String version = ec.getDescription().getVersion().split("\\.")[0];
                Economy_iConomy6.this.name = Economy_iConomy6.this.name + version;
                this.economy.economy = (iConomy)ec;
                Economy_iConomy6.this.accounts = new Accounts();
                Economy_iConomy6.this.log.info(String.format("[Economy] %s hooked.", this.economy.name));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.economy != null && event.getPlugin().getDescription().getName().equals("iConomy")) {
                this.economy.economy = null;
                Economy_iConomy6.this.log.info(String.format("[Economy] %s unhooked.", this.economy.name));
            }
        }
    }
}

