/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.utils;

import ce.ajneb97.libs.exp4j.Expression;
import ce.ajneb97.libs.exp4j.ExpressionBuilder;
import java.math.BigDecimal;
import java.util.Random;

public class MathUtils {
    public static String calculate(String str) {
        try {
            Expression expression = new ExpressionBuilder(str).build();
            if (!expression.validate().isValid()) {
                return str;
            }
            return expression.evaluate() + "";
        }
        catch (Exception e) {
            return str;
        }
    }

    public static int getRandomNumber(int min, int max) {
        Random r = new Random();
        int num = r.nextInt(max - min + 1) + min;
        return num;
    }

    public static double truncate(double value) {
        try {
            if (value > 0.0) {
                return new BigDecimal(String.valueOf(value)).setScale(2, 3).doubleValue();
            }
            return new BigDecimal(String.valueOf(value)).setScale(2, 2).doubleValue();
        }
        catch (NumberFormatException e) {
            return value;
        }
    }

    public static boolean isParsable(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        if (str.charAt(str.length() - 1) == '.') {
            return false;
        }
        if (str.charAt(0) == '-') {
            return str.length() == 1 ? false : MathUtils.withDecimalsParsing(str, 1);
        }
        return MathUtils.withDecimalsParsing(str, 0);
    }

    private static boolean withDecimalsParsing(String str, int beginIdx) {
        int decimalPoints = 0;
        for (int i = beginIdx; i < str.length(); ++i) {
            boolean isDecimalPoint;
            boolean bl = isDecimalPoint = str.charAt(i) == '.';
            if (isDecimalPoint) {
                ++decimalPoints;
            }
            if (decimalPoints > 1) {
                return false;
            }
            if (isDecimalPoint || Character.isDigit(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

