/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.managers.dependencies;

import ce.ajneb97.ConditionalEvents;
import ce.ajneb97.managers.dependencies.ProtocolLibReceiveMessageEvent;
import ce.ajneb97.model.CEEvent;
import ce.ajneb97.model.EventType;
import ce.ajneb97.model.StoredVariable;
import ce.ajneb97.model.internal.ConditionEvent;
import ce.ajneb97.utils.OtherUtils;
import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.AdventureComponentConverter;
import com.comphenix.protocol.wrappers.EnumWrappers;
import com.comphenix.protocol.wrappers.WrappedChatComponent;
import java.util.ArrayList;
import java.util.Iterator;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ProtocolLibManager {
    private ConditionalEvents plugin;

    public ProtocolLibManager(ConditionalEvents plugin) {
        this.plugin = plugin;
        this.configure();
    }

    public void configure() {
        ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.getChatAdapter(PacketType.Play.Server.CHAT));
        if (OtherUtils.isChatNew()) {
            ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.getChatAdapter(PacketType.Play.Server.SYSTEM_CHAT));
            ProtocolLibrary.getProtocolManager().addPacketListener((PacketListener)this.getChatAdapter(PacketType.Play.Server.DISGUISED_CHAT));
        }
    }

    public PacketAdapter getChatAdapter(PacketType type) {
        return new PacketAdapter((Plugin)this.plugin, ListenerPriority.HIGHEST, new PacketType[]{type}){

            public void onPacketSending(PacketEvent event) {
                String normalMessage;
                String jsonMessage;
                ConditionalEvents pluginInstance = (ConditionalEvents)this.plugin;
                boolean isPaper = pluginInstance.getDependencyManager().isPaper();
                ArrayList<CEEvent> validEvents = pluginInstance.getEventsManager().getValidEvents(EventType.PROTOCOLLIB_RECEIVE_MESSAGE);
                if (validEvents.size() == 0) {
                    return;
                }
                PacketContainer packet = event.getPacket();
                Player player = event.getPlayer();
                for (EnumWrappers.ChatType type : packet.getChatTypes().getValues()) {
                    if (!type.equals((Object)EnumWrappers.ChatType.GAME_INFO)) continue;
                    return;
                }
                if (isPaper && OtherUtils.isChatNew()) {
                    Iterator iterator = packet.getBooleans().getValues().iterator();
                    while (iterator.hasNext()) {
                        boolean b = (Boolean)iterator.next();
                        if (!b) continue;
                        return;
                    }
                }
                for (Object object : packet.getModifier().getValues()) {
                    if (object == null) continue;
                    jsonMessage = null;
                    normalMessage = null;
                    if (object instanceof String) {
                        jsonMessage = (String)object;
                        normalMessage = OtherUtils.fromJsonMessageToNormalMessage(jsonMessage);
                    } else if (object instanceof BaseComponent[]) {
                        BaseComponent[] baseComponents = (BaseComponent[])object;
                        normalMessage = BaseComponent.toLegacyText((BaseComponent[])baseComponents);
                        jsonMessage = ComponentSerializer.toString((BaseComponent[])baseComponents);
                    }
                    if (isPaper && OtherUtils.isChatNew() && object instanceof Component) {
                        WrappedChatComponent wrappedChatComponent = AdventureComponentConverter.fromComponent((Component)((Component)object));
                        jsonMessage = wrappedChatComponent.getJson();
                        normalMessage = OtherUtils.fromJsonMessageToNormalMessage(jsonMessage);
                    }
                    if (jsonMessage == null || normalMessage == null) continue;
                    ProtocolLibManager.this.executeEvent(player, jsonMessage, normalMessage, event);
                    return;
                }
                for (WrappedChatComponent wrappedChatComponent : packet.getChatComponents().getValues()) {
                    if (wrappedChatComponent == null) continue;
                    jsonMessage = wrappedChatComponent.getJson();
                    normalMessage = null;
                    normalMessage = isPaper && OtherUtils.isChatNew() ? LegacyComponentSerializer.legacyAmpersand().serialize(AdventureComponentConverter.fromWrapper((WrappedChatComponent)wrappedChatComponent)) : OtherUtils.fromJsonMessageToNormalMessage(jsonMessage);
                    if (jsonMessage != null && normalMessage != null) {
                        ProtocolLibManager.this.executeEvent(player, jsonMessage, normalMessage, event);
                    }
                    return;
                }
            }
        };
    }

    public void executeEvent(Player player, String jsonMessage, String normalMessage, PacketEvent event) {
        ProtocolLibReceiveMessageEvent messageEvent = new ProtocolLibReceiveMessageEvent(player, jsonMessage, normalMessage);
        ConditionEvent conditionEvent = new ConditionEvent(this.plugin, player, messageEvent, EventType.PROTOCOLLIB_RECEIVE_MESSAGE, null);
        conditionEvent.addVariables(new StoredVariable("%json_message%", jsonMessage), new StoredVariable("%normal_message%", normalMessage.replace("\u00a7", "&")), new StoredVariable("%normal_message_without_color_codes%", ChatColor.stripColor((String)normalMessage))).checkEvent();
        if (messageEvent.isCancelled()) {
            event.setCancelled(true);
        }
    }
}

