/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.managers;

import ce.ajneb97.libs.centeredmessages.DefaultFontInfo;
import ce.ajneb97.utils.OtherUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.command.CommandSender;

public class MessagesManager {
    private String timeSeconds;
    private String timeMinutes;
    private String timeHours;
    private String timeDays;
    private String prefix;
    private String placeholderAPICooldownReady;
    private String placeholderAPICooldownNameError;

    public String getTimeSeconds() {
        return this.timeSeconds;
    }

    public void setTimeSeconds(String timeSeconds) {
        this.timeSeconds = timeSeconds;
    }

    public String getTimeMinutes() {
        return this.timeMinutes;
    }

    public void setTimeMinutes(String timeMinutes) {
        this.timeMinutes = timeMinutes;
    }

    public String getTimeHours() {
        return this.timeHours;
    }

    public void setTimeHours(String timeHours) {
        this.timeHours = timeHours;
    }

    public String getTimeDays() {
        return this.timeDays;
    }

    public void setTimeDays(String timeDays) {
        this.timeDays = timeDays;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPlaceholderAPICooldownReady() {
        return this.placeholderAPICooldownReady;
    }

    public void setPlaceholderAPICooldownReady(String placeholderAPICooldownReady) {
        this.placeholderAPICooldownReady = placeholderAPICooldownReady;
    }

    public String getPlaceholderAPICooldownNameError() {
        return this.placeholderAPICooldownNameError;
    }

    public void setPlaceholderAPICooldownNameError(String placeholderAPICooldownNameError) {
        this.placeholderAPICooldownNameError = placeholderAPICooldownNameError;
    }

    public void sendMessage(CommandSender sender, String message, boolean prefix) {
        if (!message.isEmpty()) {
            if (prefix) {
                sender.sendMessage(MessagesManager.getColoredMessage(this.prefix + message));
            } else {
                sender.sendMessage(MessagesManager.getColoredMessage(message));
            }
        }
    }

    public static String getColoredMessage(String message) {
        if (OtherUtils.isNew()) {
            Pattern pattern = Pattern.compile("#[a-fA-F0-9]{6}");
            Matcher match = pattern.matcher(message);
            while (match.find()) {
                String color = message.substring(match.start(), match.end());
                message = message.replace(color, ChatColor.of((String)color) + "");
                match = pattern.matcher(message);
            }
        }
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        return message;
    }

    public static String getCenteredMessage(String message) {
        int CENTER_PX = 154;
        int messagePxSize = 0;
        boolean previousCode = false;
        boolean isBold = false;
        for (char c : message.toCharArray()) {
            if (c == '\u00a7') {
                previousCode = true;
                continue;
            }
            if (previousCode) {
                previousCode = false;
                if (c == 'l' || c == 'L') {
                    isBold = true;
                    continue;
                }
                isBold = false;
                continue;
            }
            DefaultFontInfo dFI = DefaultFontInfo.getDefaultFontInfo(c);
            messagePxSize += isBold ? dFI.getBoldLength() : dFI.getLength();
            ++messagePxSize;
        }
        int halvedMessageSize = messagePxSize / 2;
        int toCompensate = CENTER_PX - halvedMessageSize;
        int spaceLength = DefaultFontInfo.SPACE.getLength() + 1;
        StringBuilder sb = new StringBuilder();
        for (int compensated = 0; compensated < toCompensate; compensated += spaceLength) {
            sb.append(" ");
        }
        return sb.toString() + message;
    }
}

