/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.configs;

import ce.ajneb97.ConditionalEvents;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class PlayerConfig {
    private FileConfiguration config = null;
    private File configFile = null;
    private String filePath;
    private ConditionalEvents plugin;

    public PlayerConfig(String filePath, ConditionalEvents plugin) {
        this.filePath = filePath;
        this.plugin = plugin;
    }

    public String getPath() {
        return this.filePath;
    }

    public FileConfiguration getConfig() {
        if (this.config == null) {
            this.reloadPlayerConfig();
        }
        return this.config;
    }

    public void registerPlayerConfig() {
        this.configFile = new File(this.plugin.getDataFolder() + File.separator + "players", this.filePath);
        if (!this.configFile.exists()) {
            try {
                this.configFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.config = new YamlConfiguration();
        try {
            this.config.load(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void savePlayerConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reloadPlayerConfig() {
        if (this.config == null) {
            this.configFile = new File(this.plugin.getDataFolder() + File.separator + "players", this.filePath);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        if (this.configFile != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
            this.config.setDefaults((Configuration)defConfig);
        }
    }
}

