/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.configs;

import ce.ajneb97.ConditionalEvents;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class CEConfig {
    private String fileName;
    private FileConfiguration fileConfiguration = null;
    private File file = null;
    private String route;
    private ConditionalEvents plugin;
    private String folderName;
    private boolean firstTime;

    public CEConfig(String fileName, ConditionalEvents plugin, String folderName) {
        this.fileName = fileName;
        this.plugin = plugin;
        this.firstTime = false;
        this.folderName = folderName;
    }

    public String getPath() {
        return this.fileName;
    }

    public void registerConfig() {
        this.file = this.folderName != null ? new File(this.plugin.getDataFolder() + File.separator + this.folderName, this.fileName) : new File(this.plugin.getDataFolder(), this.fileName);
        this.route = this.file.getPath();
        if (!this.file.exists()) {
            this.firstTime = true;
            this.getConfig().options().copyDefaults(true);
            this.saveConfig();
            this.firstTime = false;
        }
    }

    public void saveConfig() {
        try {
            this.fileConfiguration.save(this.file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration getConfig() {
        if (this.fileConfiguration == null) {
            this.reloadConfig();
        }
        return this.fileConfiguration;
    }

    public boolean reloadConfig() {
        if (this.fileConfiguration == null) {
            this.file = this.folderName != null ? new File(this.plugin.getDataFolder() + File.separator + this.folderName, this.fileName) : new File(this.plugin.getDataFolder(), this.fileName);
        }
        this.fileConfiguration = CEConfig.loadConfiguration(this.file);
        if (this.firstTime) {
            try {
                InputStreamReader defConfigStream = this.folderName != null ? new InputStreamReader(this.plugin.getResource(this.folderName + "/" + this.fileName), "UTF8") : new InputStreamReader(this.plugin.getResource(this.fileName), "UTF8");
                if (defConfigStream != null) {
                    YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)defConfigStream);
                    this.fileConfiguration.setDefaults((Configuration)defConfig);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return this.fileConfiguration != null;
    }

    public static YamlConfiguration loadConfiguration(@NotNull File file) {
        Validate.notNull((Object)file, (String)"File cannot be null");
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Cannot load " + file, ex);
            return null;
        }
        catch (InvalidConfigurationException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Cannot load " + file, ex);
            return null;
        }
        return config;
    }

    public String getRoute() {
        return this.route;
    }
}

