/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.editor;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.api.Panel;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class CommandPanelsEditor
implements CommandExecutor {
    CommandPanels plugin;

    public CommandPanelsEditor(CommandPanels pl) {
        this.plugin = pl;
    }

    public boolean onCommand(final CommandSender sender, Command cmd, String label, final String[] args) {
        if (sender.hasPermission("commandpanel.edit")) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Cannot execute command in Console!"));
                return true;
            }
            if (args.length == 0) {
                sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.GREEN + "Access the web editor at the link below"));
                sender.sendMessage(this.plugin.tex.colour(ChatColor.YELLOW + "https://CommandPanels.net/editor"));
                return true;
            }
            if (args.length == 1) {
                for (Panel panel : this.plugin.panelList) {
                    if (!panel.getFile().getName().equals(args[0])) continue;
                    String filePath = panel.getFile().getAbsolutePath();
                    String fileContents = this.readFileAsString(filePath);
                    Path panelsFolderPath = this.plugin.panelsf.toPath();
                    Path panelFilePath = panel.getFile().toPath();
                    Path relativePanelPath = panelsFolderPath.relativize(panelFilePath);
                    String relativePath = relativePanelPath.toString();
                    String yamlWithFileNameAndPath = "fileName: " + relativePath.replaceFirst("[.][^.]+$", "") + "\n" + fileContents;
                    byte[] contentBytes = yamlWithFileNameAndPath.getBytes(StandardCharsets.UTF_8);
                    if (contentBytes.length > 65535) {
                        sender.sendMessage(this.plugin.tag + ChatColor.RED + "Content too long to paste in chat. Please copy and paste the panel file into the editor manually.");
                    } else {
                        BaseComponent[] components = new ComponentBuilder(this.plugin.tag + net.md_5.bungee.api.ChatColor.GREEN + "Click here to copy " + net.md_5.bungee.api.ChatColor.WHITE + panel.getFile().getName() + net.md_5.bungee.api.ChatColor.GREEN + " to the clipboard!").event(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, yamlWithFileNameAndPath)).create();
                        Player player = (Player)sender;
                        player.spigot().sendMessage(components);
                    }
                    return true;
                }
                sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Could not find panel!"));
                return true;
            }
            if (args.length == 3) {
                new BukkitRunnable(){

                    public void run() {
                        CommandPanelsEditor.this.downloadPanel(sender, args[1], args[0], args[2]);
                        CommandPanelsEditor.this.plugin.reloadPanelFiles();
                        CommandPanelsEditor.this.plugin.hotbar.reloadHotbarSlots();
                    }
                }.run();
                return true;
            }
        } else {
            sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.perms")));
            return true;
        }
        sender.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Usage: /cpe <parameters>"));
        return true;
    }

    private void downloadPanel(CommandSender sender, String userID, String fileName, String token) {
        String url = "https://firebasestorage.googleapis.com/v0/b/commandpanels-website.appspot.com/o/pastes%2F" + userID + "%2F" + fileName + "?alt=media&token=" + token;
        this.plugin.downloader.downloadPanel(sender, url, fileName);
    }

    private String readFileAsString(String filePath) {
        try {
            Path path = Paths.get(filePath, new String[0]);
            byte[] bytes = Files.readAllBytes(path);
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

