/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.classresources.placeholders;

import com.earth2me.essentials.Essentials;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.ioclasses.legacy.MinecraftVersions;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPosition;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.PotionMeta;

public class Placeholders {
    CommandPanels plugin;

    public Placeholders(CommandPanels pl) {
        this.plugin = pl;
    }

    public String setPlaceholders(Panel panel, PanelPosition position, Player p, String str, boolean primary) {
        String[] HOLDERS = this.getPlaceholderEnds(panel, primary);
        while (str.contains(HOLDERS[0] + "cp-")) {
            try {
                String value;
                int start = str.indexOf(HOLDERS[0] + "cp-");
                int end = str.indexOf(HOLDERS[1], str.indexOf(HOLDERS[0] + "cp-") + 1);
                String identifier = str.substring(start, end).replace(HOLDERS[0] + "cp-", "").replace(HOLDERS[1], "");
                try {
                    value = this.cpPlaceholders(panel, position, p, identifier);
                }
                catch (NullPointerException er) {
                    value = "";
                }
                str = str.replace(str.substring(start, end) + HOLDERS[1], value);
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                break;
            }
        }
        return str;
    }

    public String[] getPlaceholderEnds(Panel panel, boolean primary) {
        ArrayList<String[]> values = new ArrayList<String[]>();
        values.add(new String[]{this.plugin.config.getString("placeholders.primary.start"), this.plugin.config.getString("placeholders.primary.end")});
        values.add(new String[]{this.plugin.config.getString("placeholders.secondary.start"), this.plugin.config.getString("placeholders.secondary.end")});
        if (panel != null && panel.getConfig().isSet("placeholders")) {
            if (panel.getConfig().isSet("placeholders.primary")) {
                values.set(0, new String[]{panel.getConfig().getString("placeholders.primary.start"), panel.getConfig().getString("placeholders.primary.end")});
            }
            if (panel.getConfig().isSet("placeholders.secondary")) {
                values.set(1, new String[]{panel.getConfig().getString("placeholders.secondary.start"), panel.getConfig().getString("placeholders.secondary.end")});
            }
        }
        if (primary) {
            return (String[])values.get(0);
        }
        return (String[])values.get(1);
    }

    public String cpPlaceholders(Panel panel, PanelPosition position, Player p, String identifier) {
        String point_value;
        String dataPoint;
        String matNumber;
        String slot_key;
        switch (identifier) {
            case "player-displayname": {
                return p.getDisplayName();
            }
            case "player-name": {
                return p.getName();
            }
            case "player-world": {
                return p.getWorld().getName();
            }
            case "player-x": {
                return String.valueOf(Math.round(p.getLocation().getX()));
            }
            case "player-y": {
                return String.valueOf(Math.round(p.getLocation().getY()));
            }
            case "player-z": {
                return String.valueOf(Math.round(p.getLocation().getZ()));
            }
            case "online-players": {
                return Integer.toString(Bukkit.getServer().getOnlinePlayers().size());
            }
            case "online-players-visible": {
                int count = 0;
                for (Player temp : Bukkit.getOnlinePlayers()) {
                    if (this.isPlayerVanished(temp)) continue;
                    ++count;
                }
                return Integer.toString(count);
            }
            case "panel-position": {
                return position.toString();
            }
            case "tag": {
                return this.plugin.tex.colour(this.plugin.tag);
            }
        }
        if (panel != null) {
            for (String placeholder : panel.placeholders.keys.keySet()) {
                if (!identifier.equals(placeholder)) continue;
                try {
                    return panel.placeholders.keys.get(placeholder);
                }
                catch (Exception ex) {
                    this.plugin.debug(ex, p);
                    break;
                }
            }
        }
        if (identifier.startsWith("server-")) {
            String ip_port = identifier.replace("server-", "");
            Socket s = new Socket();
            try {
                s.connect(new InetSocketAddress(ip_port.split(":")[0], (int)Double.parseDouble(ip_port.split(":")[1])), this.plugin.config.getInt("config.server-ping-timeout"));
                s.close();
                return "true";
            }
            catch (IOException ex) {
                return "false";
            }
        }
        if (identifier.startsWith("nbt-")) {
            try {
                slot_key = identifier.replace("nbt-", "");
                Object value = this.plugin.nbt.getNBT(p.getOpenInventory().getTopInventory().getItem((int)Double.parseDouble(slot_key.split(":")[0])), slot_key.split(":")[2], slot_key.split(":")[1]);
                return value == null ? "empty" : String.valueOf(value);
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("potion-")) {
            try {
                slot_key = identifier.replace("potion-", "");
                int slotIndex = (int)Double.parseDouble(slot_key);
                ItemStack item = p.getOpenInventory().getTopInventory().getItem(slotIndex);
                if (item != null && item.hasItemMeta() && item.getItemMeta() instanceof PotionMeta) {
                    if (this.plugin.legacy.MAJOR_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_19) || this.plugin.legacy.MAJOR_VERSION == MinecraftVersions.v1_20 && this.plugin.legacy.MINOR_VERSION <= 4) {
                        return this.plugin.legacyPotion.retrievePotionData(item).replaceAll("\\s", ":");
                    }
                    PotionMeta potionMeta = (PotionMeta)item.getItemMeta();
                    return potionMeta.getBasePotionType().toString();
                }
                return "empty";
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("material-")) {
            try {
                String material;
                matNumber = identifier.replace("material-", "");
                try {
                    material = p.getOpenInventory().getTopInventory().getItem((int)Double.parseDouble(matNumber)).getType().toString();
                    if (this.plugin.legacy.MAJOR_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_12)) {
                        material = material + ":" + p.getOpenInventory().getTopInventory().getItem((int)Double.parseDouble(matNumber)).getData().getData();
                    }
                }
                catch (NullPointerException er) {
                    material = "AIR";
                }
                return material;
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("name-")) {
            try {
                String name;
                String nameNumber = identifier.replace("name-", "");
                try {
                    ItemStack item = p.getOpenInventory().getTopInventory().getItem((int)Double.parseDouble(nameNumber));
                    name = item.getType().toString().replace("_", " ");
                    if (item.hasItemMeta() && item.getItemMeta().hasDisplayName()) {
                        name = item.getItemMeta().getDisplayName();
                    }
                }
                catch (NullPointerException er) {
                    name = "";
                }
                return name;
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("lore-")) {
            try {
                String loreNumber = identifier.replace("lore-", "");
                String lore = "";
                try {
                    ItemStack item = p.getOpenInventory().getTopInventory().getItem((int)Double.parseDouble(loreNumber));
                    if (item.hasItemMeta() && item.getItemMeta().hasLore()) {
                        List ListLore = item.getItemMeta().getLore();
                        for (String list : ListLore) {
                            lore = lore + list + "\n";
                        }
                    }
                }
                catch (NullPointerException er) {
                    lore = "";
                }
                return lore;
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("stack-")) {
            try {
                int amount;
                matNumber = identifier.replace("stack-", "");
                try {
                    amount = p.getOpenInventory().getTopInventory().getItem((int)Double.parseDouble(matNumber)).getAmount();
                }
                catch (NullPointerException er) {
                    amount = 0;
                }
                return String.valueOf(amount);
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("modeldata-")) {
            try {
                int modelData;
                matNumber = identifier.replace("modeldata-", "");
                try {
                    modelData = p.getOpenInventory().getTopInventory().getItem((int)Double.parseDouble(matNumber)).getItemMeta().getCustomModelData();
                }
                catch (NullPointerException er) {
                    modelData = 0;
                }
                return String.valueOf(modelData);
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("damaged-")) {
            try {
                matNumber = identifier.replace("damaged-", "");
                boolean damaged = false;
                ItemStack itm = p.getOpenInventory().getTopInventory().getItem((int)Double.parseDouble(matNumber));
                try {
                    if (this.plugin.legacy.MAJOR_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_15)) {
                        if (itm.getType().getMaxDurability() != 0) {
                            damaged = itm.getType().getMaxDurability() - itm.getDurability() < itm.getType().getMaxDurability();
                        }
                    } else {
                        Damageable itemDamage = (Damageable)itm.getItemMeta();
                        damaged = itemDamage.hasDamage();
                    }
                }
                catch (NullPointerException er) {
                    damaged = false;
                }
                return String.valueOf(damaged);
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("identical-")) {
            try {
                String matLocSlot = identifier.replace("identical-", "");
                String matLoc = matLocSlot.split(",")[0];
                int matSlot = (int)Double.parseDouble(matLocSlot.split(",")[1]);
                boolean isIdentical = false;
                ItemStack itm = p.getOpenInventory().getTopInventory().getItem(matSlot);
                if (itm == null) {
                    return "false";
                }
                try {
                    String mmoID;
                    String mmoType;
                    ItemStack confItm = this.plugin.itemCreate.makeItemFromConfig(panel, position, panel.getConfig().getConfigurationSection("custom-item." + matLoc), p, true, true, false);
                    if (this.plugin.itemCreate.isIdentical(confItm, itm, Objects.requireNonNull(panel.getConfig().getConfigurationSection("custom-item." + matLoc)).contains("nbt"))) {
                        isIdentical = true;
                    }
                    String customItemMaterial = panel.getConfig().getString("custom-item." + matLoc + ".material");
                    if (this.plugin.getServer().getPluginManager().isPluginEnabled("MMOItems") && customItemMaterial.startsWith("mmo=") && this.plugin.isMMOItem(itm, mmoType = customItemMaterial.split("\\s")[1], mmoID = customItemMaterial.split("\\s")[2]) && itm.getAmount() <= confItm.getAmount()) {
                        isIdentical = true;
                    }
                }
                catch (NullPointerException er) {
                    isIdentical = false;
                }
                return String.valueOf(isIdentical);
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("random-")) {
            try {
                String min_max = identifier.replace("random-", "");
                int min = (int)Double.parseDouble(min_max.split(",")[0]);
                int max = (int)Double.parseDouble(min_max.split(",")[1]);
                return String.valueOf(this.plugin.getRandomNumberInRange(min, max));
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("data-")) {
            try {
                dataPoint = identifier.replace("data-", "");
                if (dataPoint.contains(",")) {
                    String dataName = dataPoint.split(",")[0];
                    String playerName = dataPoint.split(",")[1];
                    return this.plugin.panelData.getUserData(this.plugin.panelDataPlayers.getOffline(playerName), dataName);
                }
                return this.plugin.panelData.getUserData(p.getUniqueId(), dataPoint);
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("uuid-")) {
            try {
                dataPoint = identifier.replace("uuid-", "");
                if (this.plugin.panelDataPlayers.getOffline(dataPoint) == null) {
                    return "unknown";
                }
                return this.plugin.panelDataPlayers.getOffline(dataPoint).toString();
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("setdata-")) {
            try {
                point_value = identifier.replace("setdata-", "");
                String command = "set-data= " + point_value.split(",")[0] + " " + point_value.split(",")[1];
                this.plugin.commandRunner.runCommand(panel, position, p, command);
                return "";
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("mathdata-")) {
            try {
                point_value = identifier.replace("mathdata-", "");
                String command = "math-data= " + point_value.split(",")[0] + " " + point_value.split(",")[1];
                this.plugin.commandRunner.runCommand(panel, position, p, command);
                return "";
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        if (identifier.startsWith("player-online-")) {
            try {
                String playerLocation = identifier.replace("player-online-", "");
                if (identifier.endsWith("-visible")) {
                    playerLocation = playerLocation.replace("-visible", "");
                    ArrayList<Player> playerList = new ArrayList<Player>();
                    for (Player temp : Bukkit.getOnlinePlayers()) {
                        if (this.isPlayerVanished(temp)) continue;
                        playerList.add(temp);
                    }
                    if (playerList.size() >= Integer.parseInt(playerLocation)) {
                        return ((Player)playerList.get(Integer.parseInt(playerLocation) - 1)).getName();
                    }
                } else if (Bukkit.getOnlinePlayers().toArray().length >= Integer.parseInt(playerLocation)) {
                    return ((Player)Bukkit.getOnlinePlayers().toArray()[Integer.parseInt(playerLocation) - 1]).getName();
                }
                return this.plugin.tex.colour(Objects.requireNonNull(this.plugin.config.getString("config.format.offline")));
            }
            catch (Exception ex) {
                this.plugin.debug(ex, p);
                return "";
            }
        }
        try {
            if (this.plugin.econ != null && identifier.equals("player-balance")) {
                return String.valueOf(Math.round(this.plugin.econ.getBalance((OfflinePlayer)p)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public boolean isPlayerVanished(Player player) {
        if (!Bukkit.getPluginManager().isPluginEnabled("Essentials")) {
            return false;
        }
        Essentials essentials = (Essentials)Bukkit.getPluginManager().getPlugin("Essentials");
        return essentials.getUser(player).isVanished();
    }
}

